CREATE TABLE ila_users
(
  user_id INT NOT NULL AUTO_INCREMENT,
  email VARCHAR(100) NOT NULL,
  first_name VARCHAR(100) NOT NULL,
  last_name VARCHAR(1010) NOT NULL,
  user_password VARCHAR(100) NOT NULL,
  salt VARCHAR(100) NOT NULL,
  isEmailConfirmed INT NOT NULL,
  mobile_number VARCHAR(100) NOT NULL,
  user_type VARCHAR(100) NOT NULL,
  user_image VARCHAR(100) NOT NULL,
  PRIMARY KEY (user_id)
);

CREATE TABLE ila_reports
(
  report_id INT NOT NULL AUTO_INCREMENT ,
  description VARCHAR(100) NOT NULL,
  report_type VARCHAR(100) NOT NULL,
  latitude FLOAT NOT NULL,
  longitude FLOAT NOT NULL,
  report_date DATE NOT NULL,
  report_status INT NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (report_id)
);

CREATE TABLE ila_report_images
(
  id INT NOT NULL AUTO_INCREMENT ,
  image VARCHAR(100) NOT NULL,
  report_id INT NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE ila_report_feedbacks
(
  feedback_id INT NOT NULL AUTO_INCREMENT,
  feedback_description VARCHAR(100) NOT NULL,
  report_id INT NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (feedback_id)
);

CREATE TABLE ila_email_tokens
(
  id INT NOT NULL AUTO_INCREMENT,
  email_token VARCHAR(100) NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE ila_user_devices
(
  device_id INT NOT NULL AUTO_INCREMENT,
  device_type VARCHAR(100) NOT NULL,
  device_name VARCHAR(100) NOT NULL,
  os_version VARCHAR(100) NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (device_id)
);

CREATE TABLE ila_user_sessions
(
  id INT NOT NULL AUTO_INCREMENT,
  session_key VARCHAR(100) NOT NULL,
  created_at DATE NOT NULL,
  expired_in DATE NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE ila_social_providors
(
  id INT NOT NULL AUTO_INCREMENT,
  social_id VARCHAR(100) NOT NULL,
  social_email VARCHAR(100) NOT NULL,
  social_name VARCHAR(100) NOT NULL,
  sacial_type VARCHAR(100) NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE ila_password_tokens
(
  id INT NOT NULL AUTO_INCREMENT,
  password_token VARCHAR(100) NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (id)
);
